#include<iostream>
#include<vector>
using namespace std;
const int N=2e5+10;
const int LOG=18;
int n,q;
vector<int>g[N];
int a[N];
int tin[N],tout[N],timer;
int L[N],R[N];
long long sz[N];
int Old;
long long sum;
long long fenwick[N];
int up[LOG][N];

void update(int index,int val){
	while(index<=n){
		fenwick[index]+=val;
		index+=(index&(-index));
	}
}

long long get(int index){
	long long res=0;
	while(index>0){
		res+=fenwick[index];
		index-=(index&(-index));
	}
	return res;
}

long long get(int l,int r){return get(r)-get(l-1);}

void find_sz(int u,int par){
	up[0][u] = par;
	tin[u]=++timer;
	sz[u]+=a[u];
	for(int v:g[u]){
		if(v==par)continue;
		find_sz(v,u);
		sz[u]+=sz[v];
	}
	tout[u]=timer;
}

void find_ans(int u,int par){
	for(int v:g[u]){
		if(v==par)continue;
		if(sz[v]+sz[v]>sum){
			find_ans(v,u);
			return;
		}
	}
	Old=u;
	for(int v:g[u]){
		if(sz[v]+sz[v]==sum){
			if(v<u)Old=v;
			return;
		}
	}
}

bool is_ancestor(int u,int v){return tin[u]<=tin[v]&&tout[u]>=tout[v];}

int LCA(int u,int v){
	if(is_ancestor(u,v))return u;
	if(is_ancestor(v,u))return v;
	for(int i=LOG-1;i>=0;--i){
		if(is_ancestor(up[i][u],v))continue;
		u=up[i][u];
	}
	return up[0][u];
}

int lift(int u,int v){
	for(int i=LOG-1;i>=0;--i){
		if(is_ancestor(up[i][u],v))continue;
		u=up[i][u];
	}
	return u;
}

int main(){
	scanf("%d",&n);
	for(int i=1;i<n;++i){
		int u,v;
		scanf("%d%d",&u,&v);
		g[u].push_back(v);
		g[v].push_back(u);
	}
	tout[0]=1e9;
	for(int i=1;i<=n;++i)scanf("%d",&a[i]);
	find_sz(1,0);
	sum=sz[1];
	find_ans(1,0);
	printf("%d\n",Old);
	for(int i=n;i>0;--i)update(tin[i],a[i]);
	for(int j=1;j<LOG;++j)for(int i=n;i>0;--i)up[j][i]=up[j-1][up[j-1][i]];
	scanf("%d",&q);
	while(q--){
		int val,New;
		scanf("%d%d",&val,&New);
		sum+=val;
		update(tin[New],val);
		int lca=LCA(Old,New);
		int node;
		if(Old==lca)node=New;
		else if(New==lca)node=Old;
		else{
			int Old_lca=lift(Old,lca);
			int New_lca=lift(New,lca);
			if(get(tin[Old_lca],tout[Old_lca])*2LL>=sum)node=Old;
			else if(get(tin[New_lca],tout[New_lca])*2LL>=sum)node=New;
			else{
				Old=lca;
				printf("%d\n",lca);
				continue;
			}
		}
		long long nd=get(tin[node],tout[node]);
		if(nd*2LL>sum){
			Old=node;
			printf("%d\n",node);
			continue;
		}
		if(nd*2LL==sum){
			Old=min(node,(up[0][node]==0?(int)1e9:up[0][node]));
			printf("%d\n",min(node,(up[0][node]==0?(int)1e9:up[0][node])));
			continue;
		}
		for(int i=LOG-1;i>=0;i--){
			if(!up[i][node])continue;
			if(get(tin[up[i][node]],tout[up[i][node]])*2LL>=sum)continue;
			node=up[i][node];
		}
		node=up[0][node];
		if(get(tin[node],tout[node])*2LL==sum&&up[0][node]!=0){
			Old=min(node,up[0][node]);
			printf("%d\n",min(node,up[0][node]));
		}else{
			Old=node;
			printf("%d\n",node);
		}
	}
	return 0;
}